%% CIS II Galen Kinematic Calibration 
%% Can Kocabalkanli, Spring 2020
%% Apply Bernstein polynomial to data
%% Can Kocabalkanli and Nicolas Lamaison; Programming Assignment 2 - Problem 1; CIS 1, Fall 2019

function [p] = correctDistortion(q, qmax, qmin, S)
    %Scale q to box defined by qmin and qmax
    u = ScaleToBox(q, qmax, qmin);
    ux = u(1);
    uy = u(2);
    uz = u(3);
    p = [0; 0; 0];
    o = 4;  %Order of Bernstein Polynomial
    
    %Calculate p as the Bernstein polynomials multiplied by the coefficient 
    %vectors summed over i,j,k
    for i = 1:(o+1)
        for j = 1:(o+1)
            for k = 1:(o+1)
                c = S(i+(o+1)*(j - 1)+((o+1)^2)*(k - 1), :); 
                p = p + (c*bern(o,(i-1),ux)*bern(o,(j-1),uy)*bern(o,(k-1),uz))';
            end
        end
    end
    %Re-Scale p
    p = (qmax-qmin).*p + qmin;
end